/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.property;

import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWReplyInstruction;
import filenet.vw.api.VWSchema;
import filenet.vw.api.VWWebServiceParameterDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.property.VWReplyCorrelationSetPanel;
import filenet.vw.toolkit.runtime.property.VWReplyGeneralPanel;
import filenet.vw.toolkit.runtime.property.VWSystemStepGeneralPanel;
import filenet.vw.toolkit.runtime.property.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWTable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class VWReplyParamPanel
extends JPanel {
    protected static final int MODE_BASIC = 0;
    protected static final int MODE_ADVANCED = 1;
    protected static final int MODE_FAULT = 2;
    private static final int TAB_COUNT = 2;
    private static final int TAB_GENERAL = 0;
    private static final int TAB_CORRELATION_SET = 1;
    private VWSystemStepGeneralPanel m_parent = null;
    private DefaultTableCellRenderer m_tableCellRenderer = null;
    private VWInstructionDefinition m_instructionDef = null;
    private VWReplyGeneralPanel m_generalPanel = null;
    private VWReplyCorrelationSetPanel m_correlationSetPanel = null;
    protected JTabbedPane m_replyTabbedPane = null;

    public VWReplyParamPanel(VWSystemStepGeneralPanel parent, DefaultTableCellRenderer tableCellRenderer, VWInstructionDefinition instruction) {
        this.m_parent = parent;
        this.m_tableCellRenderer = tableCellRenderer;
        this.m_instructionDef = instruction;
        this.init();
    }

    public void setInstructionDefinition(VWInstructionDefinition instructionDef) {
        if (instructionDef instanceof VWReplyInstruction) {
            VWReplyInstruction reply = (VWReplyInstruction)instructionDef;
            this.m_instructionDef = reply;
            this.m_generalPanel.setInstructionDefinition(reply);
            this.m_correlationSetPanel.setInstructionDefinition(reply);
            if (this.getReplyMessageType() == 1) {
                if (this.m_replyTabbedPane.getTabCount() < 2) {
                    this.m_replyTabbedPane.addTab(VWResource.s_correlationSet, this.m_correlationSetPanel);
                }
            } else if (this.m_replyTabbedPane.getTabCount() == 2) {
                this.m_replyTabbedPane.removeTabAt(1);
            }
        }
    }

    private void init() {
        this.setupLayout();
        this.m_replyTabbedPane.setTabPlacement(1);
        this.m_generalPanel = new VWReplyGeneralPanel(this, this.m_tableCellRenderer, this.m_instructionDef);
        this.m_correlationSetPanel = new VWReplyCorrelationSetPanel(this, this.m_tableCellRenderer, this.m_instructionDef);
        this.m_replyTabbedPane.addTab(VWResource.s_general, this.m_generalPanel);
        this.m_replyTabbedPane.addTab(VWResource.s_correlationSet, this.m_correlationSetPanel);
    }

    private void setupLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.weightx = 1.0;
        gbCons.weighty = 1.0;
        gbCons.fill = 1;
        gbCons.anchor = 10;
        this.m_replyTabbedPane = new JTabbedPane();
        this.add((Component)this.m_replyTabbedPane, gbCons);
    }

    protected int getReplyMessageType() {
        int mode = -1;
        try {
            if (this.m_instructionDef != null) {
                String faultName = ((VWReplyInstruction)this.m_instructionDef).getFaultName();
                String outgoingMsg = ((VWReplyInstruction)this.m_instructionDef).getMessageExpr();
                String schema = ((VWReplyInstruction)this.m_instructionDef).getMessageFromSchemaName();
                String element = ((VWReplyInstruction)this.m_instructionDef).getMessageFromElementName();
                mode = faultName != null ? 2 : (outgoingMsg != null && schema != null && element != null ? 1 : 0);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mode;
    }

    protected Object getTypeFromParam(VWWebServiceParameterDefinition paramDef) {
        return this.m_parent.getTypeFromParam(paramDef);
    }

    protected void setTextField(JTextField field, String text) {
        this.m_parent.setTextField(field, text);
    }

    protected VWSchema getSchemaFromWorkflow(String name) {
        return this.m_parent.getSchemaFromWorkflow(name);
    }

    protected void setupTableCellRenderer(VWTable table, AbstractTableModel tableModel) {
        this.m_parent.setupTableCellRenderer(table, tableModel);
    }

    public void removeReferences() {
        if (this.m_generalPanel != null) {
            this.m_generalPanel.removeReferences();
        }
        if (this.m_correlationSetPanel != null) {
            this.m_correlationSetPanel.removeReferences();
        }
        this.m_replyTabbedPane = null;
        this.m_parent = null;
        this.m_tableCellRenderer = null;
        this.m_instructionDef = null;
    }
}

